package nwcomm.server.multithreaded;

import java.io.*;
import java.net.Socket;
import romanconvertorlogic.RomanConvertorLogic;

class ServeOneClient extends Thread {
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;

    private BufferedWriter logfile;

    public ServeOneClient (Socket s) throws IOException {
        socket = s;
        System.out.println("Connectie aanvaard : "+ socket);

        //read what client has to say :
        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

        // send output to client
        out = new PrintWriter(
                            new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                            true);

        start(); //calls run()
    }

    @Override
    public void run() {
      try {
        System.out.println("Connectie aanvaard : "+ socket);

        //read name from client
        String name = in.readLine();
        System.out.println("Connected client : " + name);

        // server logs to file
        logfile = new BufferedWriter(new FileWriter("./log/" + name + ".dat"));

        //read translation request from client
        String str = in.readLine();
        while (!str.equalsIgnoreCase("END") )
        {
              String translation = RomanConvertorLogic.translate(str);
              System.out.println(str + " - Translation: " + translation);

              //send translation to client
              out.println(translation); 
              logfile.write(str + "\r\n");

              str = in.readLine();
        }
        
        out.close();
        logfile.close();

      } catch (Exception e) {
            System.err.println(e.getMessage());
      } finally {
        System.out.println("closing server...");

        try {
            out.close();
            logfile.close();
            socket.close();
        } catch (Exception e) {}
      }
    }
  }
