package nwcomm.server.singlethreaded;

import java.io.*;
import java.net.*;
import romanconvertorlogic.*;

public class TranslatorServer {  
  public static final int PORT = 1234;
  
  public static void main(String[] args) throws IOException {
    ServerSocket s = new ServerSocket(PORT);
    System.out.println("Started: " + s);

    try {
      Socket socket = s.accept();
      try {
        System.out.println("Client connection accepted : " + socket);

        //read what client has to say :
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        
        // send output to client
        PrintWriter out = new PrintWriter(
                            new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                            true);

        //read name from client
        String name = in.readLine();
        System.out.println("Connected client : " + name);

        // server logs to file
        BufferedWriter logfile = new BufferedWriter(new FileWriter("./log/" + name + ".dat"));

        //read translation request from client
        String str = in.readLine();
        while (!str.equalsIgnoreCase("END") )
        {
              String translation = RomanConvertorLogic.translate(str);
              System.out.println(str + " - Translation: " + translation);

              //send translation to client
              out.println(translation); 
              logfile.write(str + "\r\n");

              str = in.readLine();
        }

        out.close();
        logfile.close();
        
      } catch (Exception e) {
            System.err.println(e.getMessage());
      } finally {
        System.out.println("Closing server...");
        socket.close();
      }
    } finally {
      s.close();
    }
  } 
}