package nwcomm_workshopRomanTranslator.client;

import be.ikdoeict.Input;
import java.net.*;
import java.io.*;

public class TranslatorConsoleClient {
  public static final int PORT = 1234;
  private static String name;

  public static void main(String[] args) throws IOException {
    System.out.println("Identify yourself!");
    name = Input.readLine();

    String request = "";
    System.out.println("Give the values to translate. \nTo end,type 'END' or 'end'");

    InetAddress addr = InetAddress.getByName(null);
    Socket socket = new Socket(addr, PORT);

    try {
          //read answer from server :
          BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

          //send request to server
          PrintWriter out = new PrintWriter(
                            new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                            true);

          //send name to server
          out.println(name);
          
	  while (!request.equalsIgnoreCase("END")) {
          //read translation request from console and send to server
          System.out.print("> ");
	      request = Input.readLine();
          out.println(request);

          //read answer from server and print it on screen
          String reply = in.readLine();
          System.out.println("server reply: " + reply);
      }
    } finally {
      System.out.println("Closing client application...");
      socket.close();
    }
  }
}