package nwcomm_workshopBasics.server;

import java.io.*;
import java.net.*;

public class Vb4_ServerMultithreaded {
    public static final int PORT = 8080;

    public static void main(String[] args) throws IOException {
        ServerSocket s = new ServerSocket(PORT);
        System.out.println("Started: " + s);

        try {
            // Onderstaande accept wacht oneindig op binnenkomende connecties
            // Voor elke gevraagde communicatie instantieert de server een socket
            // en delegeert aan een Thread klasse die de verwerking doet van de communicatie

            while (true) {
                Socket socket = s.accept();
                try {
                    new ServeOneClient(socket);
                } catch (IOException e) {
                    socket.close();
                }
            }
        } finally {
            s.close();
        }
    }
}

