package nwcomm_workshopBasics.server;

import java.io.*;
import java.net.*;

public class Vb3_ServerWithLogging {
  // Kies poortnummer voor service (buiten range 1-1024):
  public static final int PORT = 8080;
  
  public static void main(String[] args) throws IOException {
    ServerSocket s = new ServerSocket(PORT);
    System.out.println("Server started: " + s);

    try {
      // Onderstaande accept wacht op een binnenkomende connectie
      // Voor die gevraagde communicatie instantieert de server een socket
      Socket socket = s.accept();
      try {
        System.out.println("Connection accepted : "+ socket);

        //lezen wat de client te vertellen heeft :
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        
        // zelf output sturen naar client (automatisch flushen via PrintWriter):
        PrintWriter out = new PrintWriter(
                      new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                      true);
        
        //lees naam in van klant
        String name = in.readLine();
        System.out.println("Name of client : " + name);
        out.println("Server reply: " + name);

        // zelf output sturen naar bestand
        new File("./testdata").mkdirs();
        BufferedWriter outFile = new BufferedWriter(new FileWriter("./testdata/" + name + ".dat"));


        //server leest boodschappen van client tot de afgesproken tekst "END" of "end" binnenkomt
        String str = in.readLine();
        while (!str.equalsIgnoreCase("END") )
        {
                  out.println("Server reply: " + str);

                  System.out.println("Log to file : " + str);
                  outFile.write(str + "\r\n");
                  str = in.readLine();
        }

        out.println("Server closing connection");
        out.close();
        outFile.close();

      } catch (Exception e) {
            System.err.println(e.getMessage());
      } finally { 
        System.out.println("closing server...");
        socket.close();
      }
    } finally {
      // ServerSocket niet vergeten afsluiten...
      s.close();
    }
  } 
  
//    private static File getRelativeToCurrentPackage(String node) {
//        String myPackageName = new Vb3_ServerWithLogging().getClass().getPackage().getName();
//        System.out.println("myPackageName = " + myPackageName);
//
//        String docPath = myPackageName.replace(".","\\");
//        System.out.println("docPath = " + docPath);
//        docPath += "\\";
//        System.out.println("docPath = " + docPath);
//
//        URL docURL = ClassLoader.getSystemResource(docPath);
//        System.out.println("docURL (toString) = " + docURL.toString());
//        System.out.println("docURL (external form) = " + docURL.toExternalForm());
//
//        String docURLbasis = (docURL.toString()).substring(docURL.toString().lastIndexOf(':')-1);
//        docURLbasis = docURLbasis.replace("%20"," ");
//        docURLbasis = docURLbasis.replace("%5c","/");
//        System.out.println("docURLbasis = " + docURLbasis);
//
//        return (new File(docURLbasis, node));
//  }

}