package nwcomm_workshopBasics.server;

// Eenvoudige server die alles echoot wat een geconnecteerde client zendt
// Echo op console en naar de client
import java.io.*;
import java.net.*;

public class Vb1_Server {
    // Kies poortnummer voor service (buiten range 1-1024):

    public static final int PORT = 8080;

    public static void main(String[] args) throws IOException {
        ServerSocket s = new ServerSocket(PORT);
        System.out.println("Server started: " + s);
        try {
            // Onderstaande accept wacht op een binnenkomende connectie
            // Voor die gevraagde communicatie instantieert de server een socket
            Socket socket = s.accept();
            try {
                System.out.println("Connectie aanvaard : " + socket);

                //lezen wat de client te vertellen heeft :
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

                // zelf output sturen naar client (automatisch flushen via PrintWriter):
                PrintWriter out = new PrintWriter(
                        new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                        true);

                //server leest boodschappen van client tot de afgesproken tekst "END" binnenkomt
                while (true) {
                    String str = in.readLine();
                    if (str.equals("END")) {
                        break;
                    }
                    System.out.println("Echoing: " + str);
                    out.println(str);
                }
            } catch (Exception e) {
                //System.err.println(e.getMessage());
            } finally {
                System.out.println("closing server...");
                socket.close();
            }
        } finally {
            // ServerSocket niet vergeten afsluiten...
            s.close();
        }
    }
}