/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nwcomm_workshopBasics.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

class ServeOneClient extends Thread {

    private Socket socket;

    public ServeOneClient(Socket s) throws IOException {
        socket = s;
        System.out.println("Connection accepted : " + socket);

        start(); //calls run()
    }

    @Override
    public void run() {
        try {
            //lezen wat de client te vertellen heeft :
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));

            // zelf output sturen naar client (automatisch flushen via PrintWriter):
            PrintWriter out = new PrintWriter(
                    new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                    true);

            //lees naam in van klant
            String name = in.readLine();
            System.out.println("Name of the client : " + name);
            out.println("Server reply: " + name);

            // zelf output sturen naar bestand
            new File("./testdata").mkdirs();
            BufferedWriter outFile = new BufferedWriter(new FileWriter("./testdata/" + name + ".dat"));

            //server leest boodschappen van client tot de afgesproken tekst "END" of "end" binnenkomt
            String str = in.readLine();
            while (!str.equalsIgnoreCase("END")) {
                out.println("Server reply: " + str);

                System.out.println("Log to file (" + name + "): " + str);
                outFile.write(str + "\r\n");
                str = in.readLine();
            }
            
            out.println("Server closing connection");
            out.close();
            outFile.close();

        } catch (IOException e) {
        } finally {
            System.out.println("closing server connection...");
            try {
                socket.close();
            } catch (IOException e) {
            }
        }
    }
}
