package nwcomm_workshopBasics.dns;

// Eenvoudige client die lijnen tekst stuurt naar de server 
// en de lijnen tekst van de server inleest.
import java.net.*;

public class Dns {

    public static final int PORT = 8080;

    public static void main(String[] args) {
        try {
            // InetAddress.getByName(null) resulteert in speciaal "Local Loopback" IP address,
            // om te testen zonder netwerk
            // Alternatieven :
            //      InetAddress addr = InetAddress.getByName("127.0.0.1");
            //      InetAddress addr = InetAddress.getByName("localhost");
            //      InetAddress addr = InetAddress.getLocalHost();

            InetAddress addr;
            addr = InetAddress.getByName("www.google.com");
            System.out.println("addr = " + addr);

            addr = InetAddress.getByName("74.125.77.104");
            System.out.println("addr = " + addr);

            addr = InetAddress.getByAddress(new byte[] {74,125,77,104});
            System.out.println("addr = " + addr);

            addr = InetAddress.getLocalHost();
            System.out.println("addr = " + addr);

        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}