package nwcomm_workshopBasics.client;

// Eenvoudige client die lijnen tekst stuurt naar de server 
// en de lijnen tekst van de server inleest.

import java.net.*;
import java.io.*;

public class Vb1_Client {
  public static final int PORT = 8080;

  public static void main(String[] args) throws IOException {
    // InetAddress.getByName(null) resulteert in speciaal "Local Loopback" IP address,
    // om te testen zonder netwerk
    // Alternatieven : 
    //      InetAddress addr = InetAddress.getByName("127.0.0.1");
    //      InetAddress addr = InetAddress.getByName("localhost");
    //      InetAddress addr = InetAddress.getLocalHost();
      
    InetAddress addr = InetAddress.getByName(null);
    System.out.println("addr = " + addr);
    //Socket socket = new Socket(addr, Vb2_Server.PORT);
	Socket socket = new Socket(addr, PORT);
    
    //Breng alle code onder in een try-finally blok om zeker te zijn dat de connectie wordt afgesloten.
    try {
          System.out.println("socket = " + socket);

          //lezen wat de server te vertellen heeft :
          BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        
          // zelf output sturen naar server (automatisch flushen via PrintWriter):
          PrintWriter out = new PrintWriter(
                            new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())),
                            true);
      
          //De slient stuurt 100 keer 'hallo x' naar de server (en print op console van client wat je gestuurd hebt)
          //Tussen elke hallo wacht de client op de echo van de server ! (en print ook die echo af)
          for (int i = 0; i < 100; i ++) {
            out.println("hello " + i);
            String str = in.readLine();
            System.out.println(str);
          }
          //Om te eindigen stuurt de client de afgesproken "END" boodschap
          out.println("END");

    } finally {
      System.out.println("closing client ...");
      socket.close();
    }
  }
}