package datastructures.__10_MyQueueCopy;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import datastructures._5_LinkedBlockingQueue.*;
import content.Person;

import java.util.Iterator;
import java.util.Queue;


public class CopyQueueProgram {
	public static void fillQueue(Queue queue) {
		queue.offer(new Person("Van Assche", "Kristien"));
		queue.offer(new Person("Escudeiro", "Nuno"));
	}

	public static void printQueue(Queue queue, String qName) {
		Iterator iter = queue.iterator();

		System.out.println(qName + ":\n");
		while (iter.hasNext()) {
			System.out.println("\t" + (Person)iter.next());
		}

		System.out.println("\n---------------------\n");
	}

	public static void main(String[] args) {
        CopyQueueProgram program = new CopyQueueProgram();
        program.runDeepCopyImplementation();
        program.runShallowCopyImplementation();
    }

    public void runDeepCopyImplementation() {
		MyDerivedQueue q1 = new MyDerivedQueue();

		fillQueue(q1);
		printQueue(q1, "original queue");

		MyDerivedQueue q2 = (MyDerivedQueue)q1.clone();
		q2.offer(new Person("Ana", "Madureira"));

		printQueue(q1, "original queue -- good");
		printQueue(q2, "copy queue -- good");
    }

    public void runShallowCopyImplementation() {
		MyBadDerivedQueue q3 = new MyBadDerivedQueue();
		fillQueue(q3);
		printQueue(q3, "original queue");

		MyBadDerivedQueue q4 = (MyBadDerivedQueue)q3.clone();
		q4.offer(new Person("Ana", "Madureira"));

		printQueue(q3, "original queue -- CHANGED!!");
		printQueue(q4, "copy queue -- CHANGED");
	}
}