package datastructures._9_Timing;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import general.Utility;

import java.util.*;

public class TimeTestHashMap {
	public static final int MAX = 50000;

	public static void main(String[] args) {
		TimeTestHashMap program = new TimeTestHashMap();
		program.execute();
	}

	public void execute() {
		/* declarations */
		double count = 0.0;
		Random rand = new Random();
		Map map = new HashMap();

		/* start timing */
		long startTime = (new Date()).getTime();

		/* fill datastructure */
		for (int i = 0; i < MAX; i++) {
			Integer input = new Integer(rand.nextInt(MAX));
			map.put(input, input);
		}
		
		/* retreive from datastructure */
		for (int i = 0; i < MAX; i++) {
			if (map.containsKey(new Integer(rand.nextInt(MAX)))) {
				count++;
			}
		}

		/* end timing */
		long stopTime = (new Date()).getTime();
		long time = stopTime - startTime;		

		/* print statistics */
		System.out.println("Time for hashmap: " + time + "ms");
		System.out.println("Found: " + Utility.roundedValue(count/MAX*100.0, 2) + "%");
	}
}