package datastructures._9_Timing;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import general.Utility;

import java.util.*;

public class TimeTestArrayList {
	public static final int MAX = 50000;

	public static void main(String[] args) {
		TimeTestArrayList program = new TimeTestArrayList();
		program.execute();
	}

	public void execute() {
		/* declarations */
		double count = 0.0;
		Random rand = new Random();
		List list = new ArrayList();

		/* start timing */
		long startTime = (new Date()).getTime();
		
		/* fill datastructure */
		for (int i = 0; i < MAX; i++) {
			list.add(new Integer(rand.nextInt(MAX)));
		}
	
		/* retrieve from datastructure */
		for (int i = 0; i < MAX; i++) {
			if(list.contains(new Integer(rand.nextInt(MAX)))) {
				count++;
			}
		}

		/* stop timing */
		long stopTime = (new Date()).getTime();
		long time = stopTime - startTime;		

		/* print statistics */
		System.out.println("Time for arraylist: " + time + "ms");
		System.out.println("found: " + Utility.roundedValue(count/MAX*100.0, 2) + "%");
	}
}