package datastructures._8_HashMap;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import be.ikdoeict.Input;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TestHashMapProgram {
	private Map map;
	
	public TestHashMapProgram() {
		this.map = new HashMap();
	}

	public void fillMap() {
		for (int i = 0; i < 5; i++) {
			if (i != 2) {
				char c = (char)(97+i);
				this.map.put(new Integer(i), new Character(c));
			}
		}

		/* duplicate element 0 */
		this.map.put(new Integer(2), new Character((char)99));
		this.map.put(new Integer(0), new Character((char)97));

		this.printMap();
	}

	public void emptyMap() {
		System.out.print("\nRemove an element (y/n): ");
		boolean repeat = Input.readChar() == 'y' ? true : false;
		
		while (repeat) {
			if (this.map.isEmpty()) {
				System.out.println("Map is Empty");
			} else {
				System.out.print("Give the key to remove: ");
				Integer key = Input.readInt();

				if (!this.map.containsKey(key)) {
					System.out.print("Map doesn't contain the key ");
					System.out.print(key.intValue());
					System.out.println(" (anymore)");
				} else {
					System.out.print("Removed value: ");
					System.out.println(map.get(key));

					this.map.remove(key);
					printMap();
				}
			}

			System.out.print("\nRemove an element (y/n): ");
			repeat = Input.readChar() == 'y' ? true : false;
		}
	}	

	private void printMap() {
		Set set = this.map.entrySet();
		Iterator iter = set.iterator();

		System.out.println("The elements of the list:");
		System.out.println("\tv - k");
		System.out.println("\t-----");

		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry)iter.next();

			Integer key = (Integer)entry.getKey();
			Character value = (Character)entry.getValue();

			System.out.print("\t" + value.charValue());
			System.out.println(" - " + key.intValue());
		}
	}

	public static void main(String[] args) {
		TestHashMapProgram program = new TestHashMapProgram();
		program.fillMap();
		program.emptyMap();
	}
}	