package datastructures._7_PalindromeApplication;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import be.ikdoeict.Input;

public class PalindromeApplication {
	public boolean check(String str) {
		Stack s = new Stack();
		LinkedBlockingQueue q = new LinkedBlockingQueue();

		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c != ' ') {
				s.push(new Character(c));
				q.offer(new Character(c));
			}
		}

		while (!s.empty()) {
			if (!s.peek().equals(q.peek())) {
				return false;
			}

			s.pop();
			q.poll();
		}

		return true;
	}

	public static void usage() {
		System.out.println("usage: java Palindrome <string>");
	}

	public static void main(String[] args) {
		try {
            System.out.println("Give word te be tested:");
            String word = Input.readLine();

            if (word.length() < 1) {
                usage();
            } else {
                PalindromeApplication p = new PalindromeApplication();
                if (p.check(word)) {
                    System.out.println("palindrome");
                } else {
                    System.out.println("no palindrome");
                }
            }
        } catch(Exception e) {
                System.out.println(e);
        }
	}
}
