package datastructures._6_Stack;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import be.ikdoeict.Input;

import java.util.Stack;
import java.util.Iterator;

public class TestStackProgram {
	private Stack stack;
	
	public TestStackProgram() {
		this.stack = new Stack();
	}

	public void fillStack() {
		for (int i = 0; i < 5; i++) {
			this.stack.push(new Integer(i));
		}

		this.printStack();
	}

	public void emptyStack() {
		System.out.print("\nRemove an element (y/n): ");
		boolean repeat = Input.readChar() == 'y' ? true : false;
		
		while (repeat) {
			if (this.stack.empty()) {
				System.out.println("Stack is Empty");
			} else {
				System.out.print("The removed element: ");
				System.out.println((Integer)this.stack.peek());

				this.stack.pop();
				this.printStack();
			}

			System.out.print("\nRemove an element (y/n): ");
			repeat = Input.readChar() == 'y' ? true : false;
		}
	}	

	private void printStack() {
		Iterator iter = this.stack.iterator();

		System.out.println("The elements of the stack:");
		while (iter.hasNext()) {
			Integer i = (Integer)iter.next();
			System.out.println("\t" + i.intValue());
		}
	}

	public static void main(String[] args) {
		TestStackProgram program = new TestStackProgram();
		program.fillStack();
		program.emptyStack();
	}
}	