package datastructures._5_LinkedBlockingQueue;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/

import java.util.concurrent.LinkedBlockingQueue;
import java.util.Queue;
import be.ikdoeict.Input;

public class TestQueuesProgram {
	private Queue queue1;
	private Queue queue2;

	public TestQueuesProgram() {
        this.queue1 = new LinkedBlockingQueue();
		this.queue2 = new MyDerivedQueue();
	}

	public void fillQueue(Queue q) {
		for (int i = 1; i <= 5; i++) {
			q.offer(new Integer(i));
		}

        System.out.println(q);
	}

	public void emptyQueue(Queue q) {
		System.out.print("\nRemove an element (y/n): ");
		boolean repeat = Input.readChar() == 'y' ? true : false;

		while (repeat) {
			if (q.isEmpty()) {
				System.out.println("Queue is Empty");
                break;
			} else {
				System.out.print("The removed element: ");
				System.out.println((Integer)q.peek());

				q.poll();

                System.out.println(q);
			}

			System.out.print("\nRemove an element (y/n): ");
			repeat = Input.readChar() == 'y' ? true : false;
		}
	}

	public static void main(String[] args) {
		TestQueuesProgram program = new TestQueuesProgram();
        program.start();
    }

    public void start() {
        fillQueue(this.queue1);
		emptyQueue(this.queue1);

		fillQueue(this.queue2);
		emptyQueue(this.queue2);
    }
}	