package datastructures._4_TreeSet;

/**
* Datastructures in Java.
*
* @author KAHO Sint-Lieven, dept. GENT, vakgroep ICT
*/
import be.ikdoeict.Input;

import java.util.Set;
import java.util.TreeSet;
import java.util.Iterator;

public class TestTreeSetProgram {
	private Set set;
	
	public TestTreeSetProgram() {
		this.set = new TreeSet();
	}

	public void fillSet() {
		for (int i = 5; i >= 0; i--) {
			if (i != 2) {
				this.set.add(new Integer(i));
			}
		}
		
		/* duplicate element 0 */
		this.set.add(new Integer(2));
		this.set.add(new Integer(0));

		this.printSet();
	}

	public void emptySet() {
		System.out.print("\nRemove an element (y/n): ");
		boolean repeat = Input.readChar() == 'y' ? true : false;
		
		while (repeat) {
			if (this.set.isEmpty()) {
				System.out.println("Set is Empty");
			} else {
				System.out.print("Give the element to remove: ");
				Integer i = Input.readInt();

				if (!this.set.contains(i)) {
					System.out.print("Set doesn't contain ");
					System.out.print(i.intValue());
					System.out.println(" (anymore)");
				} else {
					System.out.print(i.intValue());
					System.out.println(" has been removed");

					this.set.remove(i);
					printSet();
				}
			}

			System.out.print("\nRemove an element (y/n): ");
			repeat = Input.readChar() == 'y' ? true : false;
		}
	}

	private void printSet() {
        Iterator iter = this.set.iterator();


		System.out.println("The elements of the list:");
		while (iter.hasNext()) {
			Integer i = (Integer)iter.next();
			System.out.println("\t" + i.intValue());
		}
	}

	public static void main(String[] args) {
		TestTreeSetProgram program = new TestTreeSetProgram();
		program.fillSet();
		program.emptySet();
	}
}	